% Model of a semi batch bioreactor - penicillin production

% Function file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

function dndt = f(t,n,Km,KI,mumax,kd,Yxs,Ypx,Q,cSin)

dndt = zeros(4,1);     % Allocate space for the right-hand sides of the DEs

V = n(4);                    % Volume
X = n(1)/V;                  % Biomass concentration
cS = n(2)/V;                 % Sucrose concentration
cP = n(3)/V;                 % Antibiotic concentration

rX = mumax*cS*X/(Km + cS + cS^2/KI) - kd*X; % Reaction rate of biomass
rS = -(mumax/Yxs)*cS*X/(Km + cS + cS^2/KI); % Reaction rate of sucrose
rP = Ypx*cS*X/(Km + cS + cS^2/KI);          % Reaction rate of antibiotic

dndt(1) = V*rX;  % Differential equations for concentration
dndt(2) = Q*cSin + V*rS;
dndt(3) = V*rP;
dndt(4) = Q;
